/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.SimpleObservableDebug;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class Junction
extends SimpleObservableDebug {
    private double x;
    private double y;
    private int label = 0;
    private static int nextLabel = 0;
    private boolean selected = false;

    public Junction(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.label = nextLabel++;
    }

    public String toString() {
        return "Junction_" + this.label + "[" + this.x + "," + this.y + "]";
    }

    public Point2D.Double getPosition() {
        return new Point2D.Double(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void translateNoNotify(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void notifyChanged() {
        this.notifyObservers();
    }

    public void setPosition(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.notifyObservers();
    }

    public double getDistance(Junction junction) {
        return this.getPosition().distance(junction.getPosition());
    }

    public int getLabel() {
        return this.label;
    }

    public void delete() {
        this.removeAllObservers();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.notifyObservers();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Shape getShape() {
        return this.createCircle(0.17820000000000003);
    }

    public Ellipse2D createCircle(double d) {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        double_.setFrameFromCenter(this.getX(), this.getY(), this.getX() + d, this.getY() + d);
        return double_;
    }
}

