/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.BranchSet;
import edu.colorado.phet.circuitconstructionkit.model.CCKDefaults;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Filament;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Toolkit;
import java.awt.geom.Point2D;

public class Bulb
extends CircuitComponent {
    private Filament filament;
    private SimpleObserver so;
    private double width;
    private boolean isSchematic = false;
    private boolean connectAtLeft = true;
    private static double filamentHeightScale = 1.0;

    public Bulb(Point2D point2D, ImmutableVector2D immutableVector2D, double d, double d2, double d3, CircuitChangeListener circuitChangeListener) {
        super(circuitChangeListener, point2D, immutableVector2D, d, d3);
        this.width = d2;
        this.setKirkhoffEnabled(false);
        this.init(circuitChangeListener);
        this.setKirkhoffEnabled(true);
    }

    public Bulb(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, double d, double d2, double d3, boolean bl) {
        super(circuitChangeListener, junction, junction2, d2, d3);
        this.width = d;
        super.setHeight(d3);
        this.init(circuitChangeListener);
        this.setSchematic(bl, null);
    }

    public static void setHeightScale(double d) {
        filamentHeightScale = d;
    }

    private void init(CircuitChangeListener circuitChangeListener) {
        double d = super.getHeight();
        this.filament = new Filament(circuitChangeListener, this.getStartJunction(), this.getEndJunction(), 3, d * filamentHeightScale, this.width * 0.8, d * 0.061);
        this.so = new SimpleObserver(){

            public void update() {
                Bulb.this.filament.recompute();
            }
        };
        this.addObserver(this.so);
        this.getStartJunction().addObserver(this.so);
        this.getEndJunction().addObserver(this.so);
        this.setResistance(10.0);
    }

    public double getWidth() {
        return this.width;
    }

    public void setStartJunction(Junction junction) {
        super.setStartJunction(junction);
        this.filament.setStartJunction(junction);
        junction.addObserver(this.so);
    }

    public void setEndJunction(Junction junction) {
        super.setEndJunction(junction);
        this.filament.setEndJunction(junction);
        junction.addObserver(this.so);
    }

    public Filament getFilament() {
        return this.filament;
    }

    public Point2D getPosition(double d) {
        if (this.isSchematic) {
            return super.getPosition(d);
        }
        if (this.containsScalarLocation(d)) {
            return this.filament.getPosition(d);
        }
        if (Double.isNaN(this.getLength())) {
            throw new RuntimeException("Length was NaN.");
        }
        Toolkit.getDefaultToolkit().beep();
        throw new RuntimeException("position not within bulb: x=" + d + ", length=" + this.getLength());
    }

    public double getLength() {
        if (this.isSchematic) {
            return this.getStartJunction().getPosition().distance(this.getEndJunction().getPosition());
        }
        return this.filament.getLength();
    }

    public double getComponentLength() {
        if (this.isSchematic) {
            return this.getLength();
        }
        return super.getLength();
    }

    public void setSchematic(boolean bl, Circuit circuit) {
        if (this.isSchematic == bl) {
            return;
        }
        this.isSchematic = bl;
        if (bl) {
            Bulb.expandToSchematic(this, circuit);
        } else {
            this.collaspeToLifelike(this, circuit);
        }
    }

    private Vector2D collaspeToLifelike(Bulb bulb, Circuit circuit) {
        double d = CCKModel.BULB_DIMENSION.getDistBetweenJunctions();
        ImmutableVector2D immutableVector2D = bulb.getDirectionVector().getInstanceOfMagnitude(d);
        Point2D.Double double_ = immutableVector2D.getDestination(bulb.getStartJunction().getPosition());
        Vector2D vector2D = new Vector2D(bulb.getEndJunction().getPosition(), double_);
        if (circuit != null) {
            Branch[] branchArray = circuit.getStrongConnections(bulb, bulb.getEndJunction());
            BranchSet branchSet = new BranchSet(circuit, branchArray);
            branchSet.addJunction(bulb.getEndJunction());
            branchSet.translate(vector2D);
        } else {
            bulb.getEndJunction().setPosition(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
        return vector2D;
    }

    private static void expandToSchematic(Bulb bulb, Circuit circuit) {
        Vector2D vector2D = new Vector2D(bulb.getStartJunction().getPosition(), bulb.getEndJunction().getPosition());
        Point2D.Double double_ = vector2D.getInstanceOfMagnitude(1.0).getDestination(bulb.getStartJunction().getPosition());
        Vector2D vector2D2 = new Vector2D(bulb.getEndJunction().getPosition(), double_);
        if (circuit != null) {
            Branch[] branchArray = circuit.getStrongConnections(bulb, bulb.getEndJunction());
            BranchSet branchSet = new BranchSet(circuit, branchArray);
            branchSet.addJunction(bulb.getEndJunction());
            branchSet.translate(vector2D2);
        } else {
            bulb.getEndJunction().setPosition(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
    }

    public boolean isSchematic() {
        return this.isSchematic;
    }

    public boolean isConnectAtLeft() {
        return this.connectAtLeft;
    }

    public void setConnectAtLeftXML(boolean bl) {
        this.connectAtLeft = bl;
        this.filament.setConnectAtRight(bl);
    }

    public void flip(Circuit circuit) {
        this.connectAtLeft = !this.connectAtLeft;
        this.filament.setConnectAtRight(this.connectAtLeft);
        double d = -1.0;
        if (this.connectAtLeft) {
            d = 1.0;
        }
        double d2 = CCKDefaults.determineTilt();
        ImmutableVector2D immutableVector2D = this.getDirectionVector();
        immutableVector2D = immutableVector2D.getRotatedInstance(d2 * 2.0 * d);
        Point2D.Double double_ = immutableVector2D.getDestination(this.getStartJunction().getPosition());
        Vector2D vector2D = new Vector2D(this.getEndJunction().getPosition(), double_);
        if (circuit != null) {
            Branch[] branchArray = circuit.getStrongConnections(this, this.getEndJunction());
            BranchSet branchSet = new BranchSet(circuit, branchArray);
            branchSet.addJunction(this.getEndJunction());
            branchSet.translate(vector2D);
        }
    }

    public double getIntensity() {
        double d;
        double d2 = Math.abs(this.getCurrent() * this.getVoltageDrop());
        if (d2 > (d = 60.0)) {
            d2 = d;
        }
        return Math.pow(d2 / d, 0.354);
    }
}

