/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public abstract class CircuitComponent
extends Branch {
    private double length;
    private double height;

    public CircuitComponent(CircuitChangeListener circuitChangeListener, Point2D point2D, ImmutableVector2D immutableVector2D, double d, double d2) {
        super(circuitChangeListener);
        this.length = d;
        this.height = d2;
        Junction junction = new Junction(point2D.getX(), point2D.getY());
        Point2D.Double double_ = immutableVector2D.getInstanceOfMagnitude(d).getDestination(point2D);
        Junction junction2 = new Junction(((Point2D)double_).getX(), ((Point2D)double_).getY());
        super.setStartJunction(junction);
        super.setEndJunction(junction2);
    }

    protected CircuitComponent(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, double d, double d2) {
        super(circuitChangeListener, junction, junction2);
        this.length = d;
        this.height = d2;
    }

    public double getLength() {
        return this.length;
    }

    public double getHeight() {
        return this.height;
    }

    public double getComponentLength() {
        return this.getLength();
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public Shape getShape() {
        Line2D.Double double_ = new Line2D.Double(this.getStartPoint(), this.getEndPoint());
        BasicStroke basicStroke = new BasicStroke((float)(this.height / 2.0), 0, 0);
        return basicStroke.createStrokedShape(double_);
    }
}

