/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;

public class Switch
extends CircuitComponent {
    boolean closed;
    private double handleAngle = 5.0;

    public Switch(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, boolean bl, double d, double d2) {
        super(circuitChangeListener, junction, junction2, d, d2);
        this.setKirkhoffEnabled(false);
        this.closed = !bl;
        this.setClosed(bl);
        this.setKirkhoffEnabled(true);
        this.setHandleAngle(bl ? Math.PI : 5.0);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        if (bl != this.closed) {
            this.closed = bl;
            if (bl) {
                super.setResistance(1.0E-8);
            } else {
                super.setResistance(1.0E11);
            }
        }
    }

    public void setHandleAngle(double d) {
        if (d == Math.PI) {
            this.setClosed(true);
        } else {
            this.setClosed(false);
        }
        this.handleAngle = d;
        this.notifyObservers();
    }

    public double getHandleAngle() {
        return this.handleAngle;
    }
}

