/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view;

import edu.colorado.phet.circuitconstructionkit.view.ImageSuite;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CCKImageSuite {
    private ImageSuite lifelikeImageSuite;
    private BufferedImage closedImage;
    private BufferedImage resistorImage;
    private ImageLoader imageLoader = new ImageLoader();
    private BufferedImage capacitorImage;
    private BufferedImage acImage;
    private BufferedImage inductorImage;
    private String inductorImageLoc = "circuit-construction-kit/images/inductor2.gif";
    private String batteryImageLocation = "circuit-construction-kit/images/AA-battery-100.gif";
    private String resistorImageLocation = "circuit-construction-kit/images/resistor.png";
    private String capImageLoc = "circuit-construction-kit/images/cap5.gif";
    private String acImageLoc = "circuit-construction-kit/images/ac.gif";

    public CCKImageSuite() throws IOException {
        this.loadImages();
    }

    public BufferedImage getParticleImage() throws IOException {
        return this.imageLoader.loadImage("circuit-construction-kit/images/electron10.png");
    }

    private void loadImages() throws IOException {
        this.resistorImage = ImageLoader.loadBufferedImage(this.resistorImageLocation);
        BufferedImage bufferedImage = ImageLoader.loadBufferedImage(this.batteryImageLocation);
        this.lifelikeImageSuite = new ImageSuite(this.resistorImage, bufferedImage, this.closedImage);
        this.capacitorImage = ImageLoader.loadBufferedImage(this.capImageLoc);
        this.acImage = ImageLoader.loadBufferedImage(this.acImageLoc);
        this.inductorImage = ImageLoader.loadBufferedImage(this.inductorImageLoc);
    }

    public ImageSuite getLifelikeSuite() {
        return this.lifelikeImageSuite;
    }

    public BufferedImage getKnifeHandleImage() {
        try {
            return this.imageLoader.loadImage("circuit-construction-kit/images/handle8.gif");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public BufferedImage getKnifeBoardImage() {
        try {
            return this.imageLoader.loadImage("circuit-construction-kit/images/knifeBoard.gif");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public BufferedImage getACVoltageSourceImage() {
        return this.acImage;
    }

    public BufferedImage getInductorImage() {
        return this.inductorImage;
    }

    public static CCKImageSuite getInstance() {
        try {
            return new CCKImageSuite();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }
}

