/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.chart;

import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.view.chart.ChartZoomControl;
import edu.colorado.phet.circuitconstructionkit.view.chart.StripChartJFCNode;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jfree.data.Range;

public abstract class AbstractFloatingChart
extends PhetPNode {
    private IClock clock;
    private TextReadout textReadout;
    private StripChartJFCNode stripChartJFCNode;
    private PSwing closeButtonPSwing;
    private JButton closeButton;
    private ClockAdapter clockListener;
    private ChartZoomControl chartZoomControl;
    private ArrayList listeners = new ArrayList();

    public AbstractFloatingChart(String string, IClock iClock) {
        this.clock = iClock;
        this.textReadout = new TextReadout();
        this.stripChartJFCNode = new StripChartJFCNode(200, 150, CCKStrings.getString("time.sec"), string);
        this.stripChartJFCNode.setDomainRange(0.0, 5.0);
        this.addChild(this.textReadout);
        this.addChild(this.stripChartJFCNode);
        this.chartZoomControl = new ChartZoomControl(this);
        this.addChild(this.chartZoomControl);
        CursorHandler cursorHandler = new CursorHandler(12);
        this.addInputEventListener(cursorHandler);
        this.textReadout.setOffset(0.0, 0.0);
        this.textReadout.setVisible(false);
        this.update();
        this.clockListener = new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                AbstractFloatingChart.this.update();
            }
        };
        this.clock.addClockListener(this.clockListener);
        try {
            this.closeButton = new JButton(new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/x-20.png")));
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFloatingChart.this.close();
                }
            });
            this.closeButtonPSwing = new PSwing(this.closeButton);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractFloatingChart.this.updateButtonLocations();
                }
            };
            this.updateButtonLocations();
            this.stripChartJFCNode.addPropertyChangeListener("bounds", propertyChangeListener);
            this.stripChartJFCNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
            this.addChild(this.closeButtonPSwing);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public IClock getClock() {
        return this.clock;
    }

    public void zoomOut() {
        this.zoom(1.2);
    }

    private void zoom(double d) {
        Range range = this.stripChartJFCNode.getVerticalRange();
        this.stripChartJFCNode.setVerticalRange(range.getLowerBound() * d, range.getUpperBound() * d);
    }

    public void zoomIn() {
        this.zoom(0.8);
    }

    private void close() {
        this.clock.removeClockListener(this.clockListener);
        this.notifyCloseButtonPressed();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyCloseButtonPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.chartClosing();
        }
    }

    private void updateButtonLocations() {
        this.closeButtonPSwing.setOffset(this.stripChartJFCNode.getFullBounds().getMaxX() - this.closeButtonPSwing.getFullBounds().getWidth(), this.stripChartJFCNode.getFullBounds().getOrigin().getY() - this.closeButtonPSwing.getFullBounds().getHeight());
        this.chartZoomControl.setOffset(this.stripChartJFCNode.getFullBounds().getOrigin().getX(), this.stripChartJFCNode.getFullBounds().getOrigin().getY() - this.chartZoomControl.getFullBounds().getHeight());
    }

    public StripChartJFCNode getStripChartJFCNode() {
        return this.stripChartJFCNode;
    }

    public void update() {
        this.updateTextBackground();
    }

    protected void updateTextBackground() {
        this.textReadout.updateBackground();
    }

    public static interface Listener {
        public void chartClosing();
    }

    static class TextReadout
    extends PhetPNode {
        private PText readout;
        private PPath textBackground = new PPath();

        public TextReadout() {
            this.textBackground.setPaint(new Color(255, 255, 255, 235));
            this.addChild(this.textBackground);
            this.readout = new PText("value");
            this.readout.setFont(new PhetFont(1, 14));
            this.readout.setTextPaint(Color.blue);
            this.addChild(this.readout);
        }

        public void updateBackground() {
            this.textBackground.setPathTo(RectangleUtils.expand(this.readout.getFullBounds(), 10.0, 10.0));
        }
    }

    public static interface ValueReader {
        public double getValue(double var1, double var3);
    }
}

