/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListener;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.components.ACVoltageSource;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ComponentEditor
extends PaintImmediateDialog {
    protected CCKModule module;
    protected CircuitComponent circuitComponent;
    private Circuit circuit;
    protected ModelSlider slider;
    protected JPanel contentPane;
    private CircuitListener circuitListener;

    public ComponentEditor(CCKModule cCKModule, String string, final CircuitComponent circuitComponent, Component component, String string2, String string3, double d, double d2, double d3, Circuit circuit) throws HeadlessException {
        super(ComponentEditor.getAncestor(component), string, false);
        if (d3 > d2) {
            System.out.println("StartValue exceeded max: " + d3 + "/" + d2);
            d3 = d2;
        } else if (d3 < d) {
            System.out.println("StartValue too low: " + d3 + "/" + d);
            d3 = d;
        }
        this.module = cCKModule;
        this.circuitComponent = circuitComponent;
        this.circuit = circuit;
        DecimalFormat decimalFormat = new DecimalFormat("0.0#");
        this.slider = new ModelSlider(string2, string3, d, d2, d3, decimalFormat);
        this.slider.getTextField().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ComponentEditor.this.slider.testCommit();
            }
        });
        this.slider.setTitleFont(this.slider.getTitleLabel().getFont().deriveFont(24.0f));
        this.slider.setNumMajorTicks(5);
        this.contentPane = new VerticalLayoutPanel();
        this.contentPane.add(this.slider);
        this.setContentPane(this.contentPane);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ComponentEditor.this.doChange(ComponentEditor.this.slider.getValue());
            }
        });
        JButton jButton = new JButton(CCKResources.getString("ComponentEditor.DoneButton"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ComponentEditor.this.slider.testCommit();
                if (bl) {
                    ComponentEditor.this.setVisible(false);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.contentPane.add(jPanel);
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                ComponentEditor.this.slider.requestSliderFocus();
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                ComponentEditor.this.circuitComponent.setEditing(true);
            }

            public void windowClosing(WindowEvent windowEvent) {
                ComponentEditor.this.circuitComponent.setEditing(false);
            }
        });
        this.circuitListener = new CircuitListenerAdapter(){

            public void branchRemoved(Branch branch) {
                if (branch == circuitComponent) {
                    ComponentEditor.this.setVisible(false);
                    ComponentEditor.this.dispose();
                }
            }
        };
        circuit.addCircuitListener(this.circuitListener);
        this.pack();
        SwingUtils.centerDialogInParent(this);
        this.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                ComponentEditor.this.validateRepaint();
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                ComponentEditor.this.validateRepaint();
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                ComponentEditor.this.validateRepaint();
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.slider.requestSliderFocus();
        }
        this.validateRepaint();
        this.circuitComponent.setEditing(bl);
    }

    public void validateRepaint() {
        this.getContentPane().invalidate();
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    protected abstract void doChange(double var1);

    private static Frame getAncestor(Component component) {
        return (Frame)SwingUtilities.getWindowAncestor(component);
    }

    public static class ACVoltageSourceEditor
    extends ComponentEditor {
        private ACVoltageSource branch;

        public ACVoltageSourceEditor(CCKModule cCKModule, ACVoltageSource aCVoltageSource, JComponent jComponent, Circuit circuit) {
            super(cCKModule, CCKStrings.getString("ac.voltage.source.editor"), aCVoltageSource, jComponent, CCKStrings.getString("BranchSource.AC"), CCKStrings.getString("ReadoutGraphic.ACVolts"), 0.0, 100.0, aCVoltageSource.getAmplitude(), circuit);
            this.branch = aCVoltageSource;
        }

        protected void doChange(double d) {
            this.branch.setAmplitude(d);
        }
    }

    public static class BatteryEditor
    extends ComponentEditor {
        public BatteryEditor(CCKModule cCKModule, CircuitComponent circuitComponent, Component component, Circuit circuit) throws HeadlessException {
            super(cCKModule, CCKResources.getString("ComponentEditor.BatteryVoltageTitle"), circuitComponent, component, CCKResources.getString("ComponentEditor.BatteryVoltageName"), CCKResources.getString("ComponentEditor.BatteryVoltageUnits"), 0.0, 100000.0, circuitComponent.getVoltageDrop(), circuit);
            if (cCKModule.getParameters().hugeRangeOnBatteries()) {
                final JCheckBox jCheckBox = new JCheckBox(CCKResources.getString("ComponentEditor.MoreVoltsCheckBox"), false);
                jCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BatteryEditor.this.setHugeRange(jCheckBox.isSelected());
                    }
                });
                this.contentPane.add(jCheckBox);
                boolean bl = circuitComponent.getVoltageDrop() > 100.0;
                this.setHugeRange(bl);
                jCheckBox.setSelected(bl);
                super.pack();
            }
        }

        private ModelSlider getSlider() {
            return this.slider;
        }

        private void setHugeRange(boolean bl) {
            ModelSlider modelSlider = this.getSlider();
            if (bl) {
                modelSlider.setRange(0.0, 100000.0);
                modelSlider.setPaintLabels(false);
                modelSlider.setValue(MathUtil.clamp(0.0, this.circuitComponent.getVoltageDrop(), 100000.0));
                super.pack();
            } else {
                int n = 100;
                modelSlider.setRange(0.0, n);
                modelSlider.setPaintLabels(true);
                modelSlider.setValue(MathUtil.clamp(0.0, this.circuitComponent.getVoltageDrop(), n));
                super.pack();
            }
        }

        protected void doChange(double d) {
            this.circuitComponent.setVoltageDrop(d);
        }
    }

    public static class BatteryResistanceEditor
    extends ComponentEditor {
        private Battery battery;

        public BatteryResistanceEditor(CCKModule cCKModule, Battery battery, Component component, Circuit circuit) {
            super(cCKModule, CCKResources.getString("ComponentEditor.BatteryResistanceTitle"), battery, component, CCKResources.getString("ComponentEditor.BatteryResistanceName"), CCKResources.getString("ComponentEditor.BatteryResistanceUnits"), 0.0, 9.0, battery.getInteralResistance(), circuit);
            this.battery = battery;
        }

        protected void doChange(double d) {
            if (d < 1.0E-8) {
                d = 1.0E-8;
            }
            this.battery.setInternalResistance(d);
        }
    }

    public static class BulbResistanceEditor
    extends ComponentEditor {
        public BulbResistanceEditor(CCKModule cCKModule, CircuitComponent circuitComponent, Component component, Circuit circuit) {
            super(cCKModule, CCKResources.getString("ComponentEditor.BulbResistanceTitle"), circuitComponent, component, CCKResources.getString("ComponentEditor.BulbResistanceName"), CCKResources.getString("ComponentEditor.ResistorResistanceUnits"), 0.0, 100.0, circuitComponent.getResistance(), circuit);
        }

        protected void doChange(double d) {
            if (d < 1.0E-8) {
                d = 1.0E-8;
            }
            this.circuitComponent.setResistance(d);
        }
    }

    public static class ResistorEditor
    extends ComponentEditor {
        public ResistorEditor(CCKModule cCKModule, CircuitComponent circuitComponent, Component component, Circuit circuit) {
            super(cCKModule, CCKResources.getString("ComponentEditor.ResistorResistanceTitle"), circuitComponent, component, CCKResources.getString("ComponentEditor.ResistorResistanceName"), CCKResources.getString("ComponentEditor.ResistorResistanceUnits"), 0.0, 100.0, circuitComponent.getResistance(), circuit);
        }

        protected void doChange(double d) {
            if (d < 1.0E-8) {
                d = 1.0E-8;
            }
            this.circuitComponent.setResistance(d);
        }
    }
}

