/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.ConstantDensityPropagator;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import java.awt.Color;

public class TimeScaleNode
extends PhetPNode {
    private CCKSimulationPanel cckSimulationPanel;
    private CCKModel model;
    private ShadowPText shadowPText;

    public TimeScaleNode(CCKSimulationPanel cCKSimulationPanel, CCKModel cCKModel) {
        this.cckSimulationPanel = cCKSimulationPanel;
        this.model = cCKModel;
        cCKModel.getParticleSet().getPropagator().addListener(new ConstantDensityPropagator.Listener(){

            public void timeScaleChanged() {
                TimeScaleNode.this.update();
            }
        });
        this.shadowPText = new ShadowPText("Hello!");
        this.shadowPText.setFont(new PhetFont(1, 16));
        this.shadowPText.setTextPaint(Color.red);
        this.shadowPText.setShadowColor(Color.black);
        this.shadowPText.setShadowOffset(1.0, 1.0);
        this.addChild(this.shadowPText);
        this.update();
    }

    private void update() {
        ConstantDensityPropagator constantDensityPropagator = this.model.getParticleSet().getPropagator();
        String string = constantDensityPropagator.getPercentString();
        if (!string.equals(constantDensityPropagator.getDecimalFormat().format(100L)) && constantDensityPropagator.getTimeScalingPercentValue() < 95.0) {
            if (this.cckSimulationPanel.getElectronsVisible()) {
                if (string.equals("1")) {
                    string = "< 1";
                }
                this.setText(CCKResources.getString("ConstantDensityPropagator.SpeedLimitReached1") + " " + string + CCKResources.getString("ConstantDensityPropagator.SpeedLimitReached2"));
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        } else {
            this.setText("");
            this.setVisible(false);
        }
    }

    public void setText(String string) {
        this.shadowPText.setText(string);
    }
}

