/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.view.CCKImageSuite;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.SwitchBodyImageNode;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class SwitchNode
extends SwitchBodyImageNode {
    private Switch switch_;
    private CCKModule module;
    private SwitchLeverNode switchLeverNode;

    public SwitchNode(CCKModel cCKModel, Switch switch_, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, switch_, jComponent, cCKModule);
        this.switch_ = switch_;
        this.module = cCKModule;
        this.switchLeverNode = new SwitchLeverNode();
        this.addChild(this.switchLeverNode);
    }

    public void delete() {
        super.delete();
        this.switchLeverNode.delete();
    }

    class SwitchLeverNode
    extends PhetPNode {
        private PNode imagePNode;
        private BufferedImage knifeHandleImage;
        private SimpleObserver switchObserver = new SimpleObserver(){

            public void update() {
                SwitchLeverNode.this.update();
            }
        };

        public SwitchLeverNode() {
            this.addInputEventListener(new CursorHandler());
            this.knifeHandleImage = CCKImageSuite.getInstance().getKnifeHandleImage();
            this.imagePNode = new PImage(this.knifeHandleImage);
            this.addChild(this.imagePNode);
            SwitchNode.this.switch_.addObserver(this.switchObserver);
            this.imagePNode.addInputEventListener(new PBasicInputEventHandler(){
                private double origGrabAngle = Double.NaN;
                private double origLeverAngle = Double.NaN;

                public void mouseDragged(PInputEvent pInputEvent) {
                    double d;
                    if (Double.isNaN(this.origGrabAngle)) {
                        this.origGrabAngle = this.getAngle(pInputEvent);
                        this.origLeverAngle = SwitchNode.this.switch_.getHandleAngle();
                    }
                    double d2 = this.getAngle(pInputEvent);
                    double d3 = d2 - this.origGrabAngle;
                    for (d = this.origLeverAngle + d3; d < 0.0; d += Math.PI * 2) {
                    }
                    while (d > Math.PI * 2) {
                        d -= Math.PI * 2;
                    }
                    if (d < Math.PI) {
                        d = Math.PI;
                    } else if (d > 5.0) {
                        d = 5.0;
                    } else if (d < 0.6) {
                        d = Math.PI;
                    }
                    SwitchNode.this.switch_.setHandleAngle(d);
                    pInputEvent.setHandled(true);
                }

                private double getAngle(PInputEvent pInputEvent) {
                    Point2D.Double double_ = new Point2D.Double(SwitchLeverNode.this.knifeHandleImage.getWidth(), SwitchLeverNode.this.knifeHandleImage.getHeight());
                    SwitchLeverNode.this.imagePNode.localToGlobal(double_);
                    SwitchNode.this.getParent().globalToLocal(double_);
                    Vector2D vector2D = new Vector2D(double_, pInputEvent.getPositionRelativeTo(SwitchNode.this.getParent()));
                    return vector2D.getAngle();
                }

                public void mouseReleased(PInputEvent pInputEvent) {
                    this.origGrabAngle = Double.NaN;
                    this.origLeverAngle = Double.NaN;
                }
            });
            this.update();
        }

        private void update() {
            this.imagePNode.setTransform(new AffineTransform());
            this.imagePNode.rotateAboutPoint(SwitchNode.this.switch_.getHandleAngle() + Math.PI, this.knifeHandleImage.getWidth(), this.knifeHandleImage.getHeight() / 2);
        }

        public void delete() {
            SwitchNode.this.switch_.removeObserver(this.switchObserver);
        }
    }
}

