/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.LineSegment;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class SchematicPlatedNode
extends ComponentNode {
    private double wireThickness;
    private Area mouseArea;
    private SimpleObserver simpleObserver;
    private double fracDistToPlate;
    private double scaleHeightLeft;
    private double scaleHeightRight;
    private PhetPPath path;
    private Shape clipShape;

    public SchematicPlatedNode(CCKModel cCKModel, CircuitComponent circuitComponent, JComponent jComponent, CCKModule cCKModule, double d, double d2, double d3, double d4) {
        super(cCKModel, circuitComponent, jComponent, cCKModule);
        this.fracDistToPlate = d2;
        this.scaleHeightLeft = d3;
        this.scaleHeightRight = d4;
        this.wireThickness = d;
        this.simpleObserver = new SimpleObserver(){

            public void update() {
                SchematicPlatedNode.this.update();
            }
        };
        this.path = new PhetPPath(Color.black);
        this.addChild(this.path);
        circuitComponent.addObserver(this.simpleObserver);
        this.update();
        this.setVisible(true);
    }

    protected void update() {
        super.update();
        Point2D.Double double_ = this.getBranch().getStartJunction().getPosition();
        Point2D.Double double_2 = this.getBranch().getEndJunction().getPosition();
        double d = this.wireThickness;
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(double_, double_2);
        Point2D.Double double_3 = immutableVector2D.getScaledInstance(this.fracDistToPlate).getDestination(double_);
        Point2D.Double double_4 = immutableVector2D.getScaledInstance(1.0 - this.fracDistToPlate).getDestination(double_);
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getInstanceOfMagnitude(1.0);
        ImmutableVector2D immutableVector2D3 = immutableVector2D2.getNormalVector();
        double d2 = d * this.scaleHeightLeft;
        double d3 = d * this.scaleHeightRight;
        Point2D.Double double_5 = immutableVector2D3.getInstanceOfMagnitude(d2).getDestination(double_3);
        Point2D.Double double_6 = immutableVector2D3.getInstanceOfMagnitude(d2).getScaledInstance(-1.0).getDestination(double_3);
        Point2D.Double double_7 = immutableVector2D3.getInstanceOfMagnitude(d3).getDestination(double_4);
        Point2D.Double double_8 = immutableVector2D3.getInstanceOfMagnitude(d3).getScaledInstance(-1.0).getDestination(double_4);
        double d4 = d / 2.0;
        Area area = new Area();
        area.add(new Area(LineSegment.getSegment(double_, double_3, d)));
        area.add(new Area(LineSegment.getSegment(double_4, double_2, d)));
        area.add(new Area(LineSegment.getSegment(double_5, double_6, d4)));
        area.add(new Area(LineSegment.getSegment(double_7, double_8, d4)));
        this.clipShape = LineSegment.getSegment(double_3, double_4, d * 10.0);
        this.mouseArea = new Area(area);
        this.mouseArea.add(new Area(LineSegment.getSegment(double_, double_2, d)));
        this.path.setPathTo(area);
        this.getHighlightNode().setStroke(new BasicStroke(0.1f));
        this.getHighlightNode().setPathTo(area);
    }

    protected Shape getClipShape() {
        return this.clipShape;
    }

    public void delete() {
        super.delete();
        this.getBranch().removeObserver(this.simpleObserver);
    }
}

