/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.SwitchBodyRectangleNode;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class SchematicSwitchNode
extends SwitchBodyRectangleNode {
    private Switch s;
    private CCKModule module;
    private SwitchLeverNode switchLeverNode;

    public SchematicSwitchNode(CCKModel cCKModel, Switch switch_, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, switch_, jComponent, cCKModule);
        this.s = switch_;
        this.module = cCKModule;
        this.switchLeverNode = new SwitchLeverNode();
        this.addChild(this.switchLeverNode);
        int n = 40;
        this.addChild(new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, n, this.getDimension().getHeight()), (Paint)Color.black));
        this.addChild(new PhetPPath((Shape)new Rectangle2D.Double(this.getDimension().getWidth() - (double)n, 0.0, n, this.getDimension().getHeight()), (Paint)Color.black));
    }

    public void delete() {
        super.delete();
        this.switchLeverNode.delete();
    }

    class SwitchLeverNode
    extends PhetPNode {
        private PNode pathNode;
        double leverWidth;
        double leverHeight;
        private SimpleObserver switchObserver;

        public SwitchLeverNode() {
            this.leverWidth = SchematicSwitchNode.this.getDimension().getWidth();
            this.leverHeight = 20.0;
            this.switchObserver = new SimpleObserver(){

                public void update() {
                    SwitchLeverNode.this.update();
                }
            };
            this.addInputEventListener(new CursorHandler());
            this.pathNode = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, this.leverWidth, this.leverHeight), (Paint)Color.black);
            this.addChild(this.pathNode);
            SchematicSwitchNode.this.s.addObserver(this.switchObserver);
            this.pathNode.addInputEventListener(new PBasicInputEventHandler(){
                private double origGrabAngle = Double.NaN;
                private double origLeverAngle = Double.NaN;

                public void mouseDragged(PInputEvent pInputEvent) {
                    double d;
                    if (Double.isNaN(this.origGrabAngle)) {
                        this.origGrabAngle = this.getAngle(pInputEvent);
                        this.origLeverAngle = SchematicSwitchNode.this.s.getHandleAngle();
                    }
                    double d2 = this.getAngle(pInputEvent);
                    double d3 = d2 - this.origGrabAngle;
                    for (d = this.origLeverAngle + d3; d < 0.0; d += Math.PI * 2) {
                    }
                    while (d > Math.PI * 2) {
                        d -= Math.PI * 2;
                    }
                    if (d < Math.PI) {
                        d = Math.PI;
                    } else if (d > 5.0) {
                        d = 5.0;
                    } else if (d < 0.6) {
                        d = Math.PI;
                    }
                    SchematicSwitchNode.this.s.setHandleAngle(d);
                    pInputEvent.setHandled(true);
                }

                private double getAngle(PInputEvent pInputEvent) {
                    Point2D.Double double_ = new Point2D.Double(SwitchLeverNode.this.leverWidth, SwitchLeverNode.this.leverHeight);
                    SwitchLeverNode.this.pathNode.localToGlobal(double_);
                    SchematicSwitchNode.this.getParent().globalToLocal(double_);
                    Vector2D vector2D = new Vector2D(double_, pInputEvent.getPositionRelativeTo(SchematicSwitchNode.this.getParent()));
                    return vector2D.getAngle();
                }

                public void mouseReleased(PInputEvent pInputEvent) {
                    this.origGrabAngle = Double.NaN;
                    this.origLeverAngle = Double.NaN;
                }
            });
            this.update();
        }

        private void update() {
            this.pathNode.setTransform(new AffineTransform());
            this.pathNode.translate(0.0, this.leverHeight);
            this.pathNode.rotateAboutPoint(SchematicSwitchNode.this.s.getHandleAngle() + Math.PI, this.leverWidth, this.leverHeight);
        }

        public void delete() {
            SchematicSwitchNode.this.s.removeObserver(this.switchObserver);
        }
    }
}

