/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.model.analysis.CircuitSolutionListener;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.LineSegment;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class SeriesAmmeterNode
extends ComponentNode {
    private SeriesAmmeter component;
    private CCKModule module;
    private Stroke stroke = new BasicStroke(0.083333336f);
    private Font font = new PhetFont(1, 17);
    private Shape shape;
    private String text = CCKResources.getString("SeriesAmmeterGraphic.Ammeter");
    private String fixedMessage;
    private SimpleObserver simpleObserver;
    private CircuitSolutionListener circuitSolutionListener;
    private int numWindows = 3;
    private PhetPPath blackGraphic;
    private PhetPPath[] windowGraphics = new PhetPPath[this.numWindows];
    private PhetPPath areaGraphic;
    private PText textGraphic;
    private Area area;

    public SeriesAmmeterNode(JComponent jComponent, final SeriesAmmeter seriesAmmeter, CCKModule cCKModule) {
        super(cCKModule.getCCKModel(), seriesAmmeter, jComponent, cCKModule);
        this.component = seriesAmmeter;
        this.module = cCKModule;
        this.simpleObserver = new SimpleObserver(){

            public void update() {
                SeriesAmmeterNode.this.changed();
            }
        };
        seriesAmmeter.addObserver(this.simpleObserver);
        this.circuitSolutionListener = new CircuitSolutionListener(){

            public void circuitSolverFinished() {
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String string = decimalFormat.format(Math.abs(seriesAmmeter.getCurrent()));
                SeriesAmmeterNode.this.text = "" + string + " " + CCKResources.getString("SeriesAmmeterGraphic.Amps");
                SeriesAmmeterNode.this.changed();
            }
        };
        cCKModule.getCCKModel().getCircuitSolver().addSolutionListener(this.circuitSolutionListener);
        this.blackGraphic = new PhetPPath(new Area(), this.stroke, (Paint)Color.black);
        this.addChild(this.blackGraphic);
        this.areaGraphic = new PhetPPath((Shape)new Area(), (Paint)Color.black);
        this.addChild(this.areaGraphic);
        for (int i = 0; i < this.windowGraphics.length; ++i) {
            this.windowGraphics[i] = new PhetPPath(new Area(), (Stroke)new BasicStroke(0.020000001f), (Paint)Color.black);
            this.addChild(this.windowGraphics[i]);
        }
        this.textGraphic = new PText();
        this.textGraphic.setFont(this.font);
        this.textGraphic.setVisible(true);
        this.getHighlightNode().setStroke(new BasicStroke(0.05f));
        this.addChild(this.textGraphic);
        this.changed();
        this.setVisible(true);
    }

    private void changed() {
        Object object;
        Serializable serializable;
        Point2D point2D;
        double d = this.component.getHeight();
        Point2D.Double double_ = this.component.getStartJunction().getPosition();
        Point2D.Double double_2 = this.component.getEndJunction().getPosition();
        this.shape = LineSegment.getSegment(double_, double_2, d);
        BasicStroke basicStroke = new BasicStroke(0.2f);
        this.getHighlightNode().setPathTo(basicStroke.createStrokedShape(this.shape));
        this.getHighlightNode().setVisible(this.component.isSelected());
        this.blackGraphic.setPathTo(this.shape);
        Vector2D vector2D = new Vector2D(double_, double_2).normalize();
        ImmutableVector2D immutableVector2D = vector2D.getNormalVector();
        double d2 = new Vector2D(double_, double_2).getAngle();
        Rectangle rectangle = this.shape.getBounds();
        this.area = new Area(this.shape);
        double d3 = 0.3;
        double d4 = this.component.getHeight() * d3;
        double d5 = double_.distance(double_2);
        double d6 = d5 / ((double)this.numWindows + 1.0);
        double d7 = (d5 - d6 * (double)this.numWindows) / (double)(this.numWindows + 1);
        double d8 = 0.0;
        immutableVector2D = immutableVector2D.getInstanceOfMagnitude(d4 / 2.0).getScaledInstance(1.0);
        for (int i = 0; i < this.numWindows; ++i) {
            point2D = vector2D.getInstanceOfMagnitude(d8 += d7).getDestination(double_);
            point2D = immutableVector2D.getDestination(point2D);
            serializable = vector2D.getInstanceOfMagnitude(d8 += d6).getDestination(double_);
            serializable = immutableVector2D.getDestination((Point2D)((Object)serializable));
            object = LineSegment.getSegment(point2D, serializable, d4);
            this.area.subtract(new Area((Shape)object));
            this.windowGraphics[i].setPathTo((Shape)object);
        }
        Point point = rectangle.getLocation();
        point2D = new Point((int)(point.getX() + rectangle.getWidth()), (int)(point.getY() + rectangle.getHeight()));
        serializable = new Color(255, 230, 250);
        object = new Color(230, 255, 230);
        this.areaGraphic.setPaint(new GradientPaint(point, (Color)serializable, point2D, (Color)object));
        this.areaGraphic.setPathTo(this.area);
        Point2D.Double double_3 = immutableVector2D.getScaledInstance(-0.04833333333333333).getDestination(double_);
        double_3 = vector2D.getInstanceOfMagnitude(0.03333333333333333).getDestination(double_3);
        String string = this.text;
        if (this.fixedMessage != null) {
            string = this.fixedMessage;
        }
        this.textGraphic.setTransform(new AffineTransform());
        this.textGraphic.setText(string);
        this.textGraphic.scale(0.016666666666666666);
        this.textGraphic.setOffset(((Point2D)double_3).getX(), ((Point2D)double_3).getY());
        this.textGraphic.rotate(d2);
    }

    public CircuitComponent getCircuitComponent() {
        return this.component;
    }

    public void delete() {
        super.delete();
        this.component.removeObserver(this.simpleObserver);
        this.module.getCCKModel().getCircuitSolver().removeSolutionListener(this.circuitSolutionListener);
    }

    public Shape getClipShape(PNode pNode) {
        Shape shape = new Area(this.area);
        PAffineTransform pAffineTransform = this.getLocalToGlobalTransform(null);
        PAffineTransform pAffineTransform2 = pNode.getGlobalToLocalTransform(null);
        shape = pAffineTransform.createTransformedShape(shape);
        shape = pAffineTransform2.createTransformedShape(shape);
        return shape;
    }
}

